﻿namespace Hims.Api.Models.Provider
{
    /// <summary>
    /// The provider charges Model
    /// </summary>
    public class ProviderCharges
    {
        /// <summary>
        /// Gets or sets the consultation charges.
        /// </summary>
        public decimal? ConsultationCharges { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine charges.
        /// </summary>
        public decimal? TelemedicineCharges { get; set; }

        /// <summary>
        /// Gets or sets the in patient charges.
        /// </summary>
        public decimal? InPatientCharges { get; set; }

        /// <summary>
        /// Gets or sets the out patient charges.
        /// </summary>
        public decimal? OutPatientCharges { get; set; }

        /// <summary>
        /// Gets or sets the casualty charges.
        /// </summary>
        public decimal? CasualtyCharges { get; set; }

        /// <summary>
        /// Gets or sets the covid charges.
        /// </summary>
        public decimal? CovidCharges { get; set; }

        /// <summary>
        /// Gets or sets the special charges.
        /// </summary>
        public decimal? SpecialCharges { get; set; }

        /// <summary>
        /// Gets or sets the availability.
        /// </summary>
        public string Availability { get; set; } = string.Empty;
    }
}